*******************************************************************************
/* Export to PDF
   -----------------------------------------------------------------------
   Programmer..: Andreas Beckhaus, Marc Van den Berghen (gs_print, gs_base)
   Date........: November 22, 2007
   Notes.......: Exporting dbase Report as PDF
   Written for.: dBPlus
   Rev. History: 22.11.2007 0.1 - Original version 
   Dependency  : Post-Script Printer-Driver (Canon C LBP 460PS is built in 2000 and XP) on FILE
                 Ghostscript for Windows - Search by Google
                 unzip the file and copy bin\gsdll32.dll and all files from the lib-Directory to one directory. 
   Calls.......: 
   Called by...: Any
   Examples....: Example 1: Convert a Report to PDF
                 SET PROC TO pdf.cc ADDI
                 p = NEW PDF()
                 p.cReportname = "testreport"
                 p.cOutput = "c:\report.pdf"
                 p.export()
                 release p

                 Example 2: Convert a Report to PDF and show it in PDF-Reader
                 SET PROC TO pdf.cc ADDI
                 p = NEW PDF()
                 p.cReportname = "testreport"
                 p.cOutput = "c:\report.pdf"
                 p.bShowPDF = true
                 p.export()
                 release p

*/

class pdf
   this.bShowPDF = false // Schow PDF after Export
   this.cDrucker =  mdriv1//"pdf24" // Printername
   this.cOutput = "" // Filename Output (pdf-File)
   this.cReportName = "" // Reportname 
   this.cGSPfad = BA1 //"c:\OPREMAD6\GS" // Path to gsdll32.dll 
   this.init()

   Function init
      IF NOT FILE(this.cGSPfad + "\gsdll32.dll")
         MSGBOX("Ghostscript is not installed. Ask your Administrator","PDF-Export",16)
      ENDIF
   return

   Function Export
      // Start PDF-Export 
      // Check Values
      DO CASE 
         CASE EMPTY(this.cOutput)
              MSGBOX("No Output-File (pdf)","PDF-Export",16)
              return
         CASE EMPTY(this.cDrucker)
              MSGBOX("No PDF-Printer","PDF-Export",16)
              return
         CASE EMPTY(this.cReportname)
              MSGBOX("No Report","PDF-Export",16)
              return
      ENDCASE

      // Filename 
      IF RAT(".PDF",UPPER(this.cOutput)) # 0
         // Remove PDF 
         this.cOutput = SUBSTR(this.cOutput,1,RAT(".PDF",UPPER(this.cOutput))-1 )
      ENDIF
      this.cInput = this.cOutput + ".ps"
      this.cOutput = this.cOutput + ".pdf"
      this.report()
      bErfolg = this.pdf_export()

      IF this.bShowPDF = true and bErfolg = true
         applib("runexe",this.cOutput)
      ENDIF
   return


   Function Report
      IF EMPTY(this.cReportname)
         return
      ENDIF
      // open and render Report
      cTmp = "SET PROC TO " + this.cReportname + ".rep addi"
      &cTmp
      cTmp = "this.rpdf = NEW " + this.cReportname + "report()"
      &cTmp
      // Output to File
      this.rpdf.printer.printername = this.cDrucker
      this.rpdf.printer.printerSource = 2
      this.rpdf.output = 2
      this.rpdf.outputfilename = (this.cInput)
      this.rpdf.render()
      this.rpdf = NULL
      return

         
   Function pdf_export
      IF NEW FILE().exists(this.cInput) = false
         // No Input-File
         return false
      ENDIF

      // Change Dir to gs-Dir
      cDir = SET("DIRECTORY")
      SET DIRECTORY TO (this.cGsPfad)

      // GS-Klasse 
      oPDF = NEW gs_print()
      oPDF.output = this.cOutput
      IF oPDF.druck(this.cInput) = false
         MSGBOX("Fehler bei PDF-Export")
         oPDF = NULL
         // Change Dir to default
         SET DIRECTORY TO &cDir
         return false
      ENDIF
      oPDF = NULL
      // Change Dir to default
      SET DIRECTORY TO &cDir

      // Delete Input-File
      NEW FILE().delete(this.cInput)

   return true

endclass

/* **********************************************************************

Klasse zur Nutzung der Ghostscript-Dll (umwandeln von Reports in pdf)

Programmierer  : Marc Van den Berghen
Datum				: 12-11-06
Revison			: 0.01

Abhngigkeiten	: gsdll32.dll    (unterliegt der GNU)
					  Achtung : gsdll32.dll bentigt zwingend die ps-Fonts.
                 Es reicht nicht, nur die DLL weiterzugeben.
                 Ghostscript muss korrekt installiert sein.	

Vorgehensweise	: Nach Erstellen eines gs_print Objekts und belegen der
    				  nicht-default Eigenschaften, kann man die Methode
					  druck aufrufen, mit dem Namen der ps-Datei die 						
					  verarbeitet werden soll als Parameter.

                 BSP. (siehe auch test.prg)

                 set procedure to gs_api.cc
                 local g
                 g = new gs_print()
                 g.output = "chess.pdf"
                 err = g.druck("chess.ps")  // false be Fehler

*************************************************************************/

Class gs_print

	this.ready  = false  // falls alle Initialisierungen klappen ---> true
	this.handle = 0      // handle auf die gs-Instanz, 

   this.papersize		= "a4"
   this.device			= "-sDEVICE=pdfwrite"
   this.settings		= "/prepress"
   this.arg1 			= "ps2pdf"
   this.arg2 			= "-dNOPAUSE"
   this.arg3		 	= "-dBATCH"
   this.arg4 			= "-dSAFER"
   this.arg5 			= "-c"
   this.arg5a			= ".setpdfwrite"
   this.arg6 			= "-f"
   this.argv 			= ""
   this.output			= "out.pdf" // kann gendert werden

   * wer weiss was er tut kann obige Properties ndern, bevor er 
   * die druck-methode aufruft...

   try
   	extern cint  gs_new(cptr clong,cptr) gsdll32 from "gsapi_new_instance"
      extern cint  gs_exit(clong) gsdll32 from "gsapi_exit"
      extern cvoid gs_delete(clong) gsdll32 from "gsapi_delete_instance"
      extern cint  gs_print(clong,cint,cptr) gsdll32 from "gsapi_init_with_args"
      this.ready = true
   catch (exception e)
		msgbox("Es trat ein Fehler bei der Initialisierung der Ghostscript-Dll auf" ;
      +chr(13) + e.message ,"GS-Print-Objekt kann nicht verwendet werden",0)
   endtry


	function druck(cfile)
   	local c1,c2,errcode,buff,argp,bret
		bret = false
   	if not this.ready
      	msgbox("Das GS-Objekt konnte nicht korrekt initialisiert werden","Aktion unmglich",0)
         return false
      endif

      if empty(cfile) 
      	msgbox("Es wurde kein Dateiname angegeben","Fehlender Parameter",0)
         return false
      endif

      this.argv  = this.arg1+" "
      this.argv += this.arg2+" "
      this.argv += this.arg3+" "
      this.argv += this.arg4+" "
		this.argv += this.device+" "
      c1 = "-sOutputFile="+this.output
      this.argv += c1+" "
      this.argv += this.arg5+" "
      this.argv += this.arg5a+" "
      this.argv += this.arg6+" "
      c2 = cfile
		this.argv += c2+" "+chr(0)

      nlen = len(this.argv)
      buff = new gs_base(40)  	// Anzahl Parameter * 4
      argp = buff.alloc(nlen)    // Reservieren eines Speicherbereichs
      argp1= argp
 
		*** Fllen des Speicherbereichs mit den Parameterwerten
      *** Gleichzeitig werden die Pointer auf die Bereiche in Buff
      *** abgelegt. So wird ein C-Argumentvektor simuliert.

 		buff.pointer(0,argp,this.arg1) ; argp+=len(this.arg1)+1
      buff.pointer(4,argp,this.arg2) ; argp+=len(this.arg2)+1
      buff.pointer(8,argp,this.arg3) ; argp+=len(this.arg3)+1
      buff.pointer(12,argp,this.arg4) ; argp+=len(this.arg4)+1
      buff.pointer(16,argp,this.device) ; argp+=len(this.device)+1
      buff.pointer(20,argp,c1) ; argp+=len(c1)+1
      buff.pointer(24,argp,this.arg5) ; argp+=len(this.arg5)+1
      buff.pointer(28,argp,this.arg5a) ; argp+=len(this.arg5a)+1
      buff.pointer(32,argp,this.arg6) ; argp+=len(this.arg6)+1
      buff.pointer(36,argp,c2) ; argp+=len(c2)+1

      try
         this.handle = 0
		  	errcode = gs_new(this.handle,null) 
         if errcode = 0
         	errcode = gs_print(this.handle,10,buff)
            if errcode # 0
            *	msgbox("Fehler bei der Umwandlung"+chr(13)+ "Fehlercode :"+errcode,"Fehler",0)
            do pdf4a
               bret = false
				else
					bret = true
            endif
         else
         	Msgbox("Konnte keine Ghostscript-Instanz erstellen"+ chr(13) + "Fehlercode : "+errcode,"Fehler",0)
			endif         
         gs_exit(this.handle)
         gs_delete(this.handle)    // unbedingt erforderlich, da immer nur eine Instanz laufen darf
      catch (exception e)
      	msgbox("Unbekannter Fehler aufgetreten !" + chr(13)+e.message+e.lineno,"Fehler",0)
         gs_exit(this.handle)
         gs_delete(this.handle)
         return false
      endtry
      buff.release()
   return bret
endclass

*** Helferklasse fr die Speicherverwaltung

#define GMEM_FIXED 0

Class gs_Base(nSize) Of String

	if empty(nSize) 
   	nSize=128
   endif
   nSize = iif((nSize % 2)=1,nSize+1,nSize)  //Enlarge to WordBorder for Unicode
	this.String = Replicate(Chr(0),nSize / 2) // Initialize with 0
	this.SizeOf = nSize                       // size of struct
   this.ptr		= 0

	extern chandle 	GlobalAlloc(CUINT, clong) kernel32
   extern chandle    GlobalFree(chandle) kernel32
   extern chandle    GetCurrentProcess( cvoid ) kernel32
   extern clogical   WriteProcessMemory(chandle, cptr, cstring, clong,cptr ) kernel32
   extern clogical   WriteProcessMemoryP(chandle, clong, cptr, clong,cptr ) kernel32 from 'WriteProcessMemory'

	this.hprocess=getcurrentprocess()

	*** Diese Funktion kopiert die Parameter an eine bestimmte Stelle
   *** im Speicher und trgt die genau Position dieses Speicherorts
   *** der Reihe nach in den String ein.

   function pointer(n,cl,c_arg)
	   this.setlong(n,cl)
	   apierror=writeprocessmemory(this.hprocess,cl,c_arg+chr(0),len(c_arg)+1,0)
   return

   function setLong(nIndex, nValue)		// set the long value at the desired 
     this.setByte(nIndex, bitand(nValue, 0xFF))    // position in the structure
     this.setByte(nIndex + 1, bitrshift(bitand(nValue, 0xFF00), 8))
     this.setByte(nIndex + 2, bitrshift(bitand(nValue, 0xFF0000), 16))
     this.setByte(nIndex + 3, bitrshift(bitand(nValue, 0xFF000000), 24))
   return 

   function release()		// cleanup
     this.string = ''
     if not empty(this.ptr)
			globalfree(this.ptr)
     endif
     release object this
   return

   function alloc(nlen)
   	local h
      h=globalalloc(GMEM_FIXED,nlen+1)// get the address
      if h=0
         Msgbox("Memory allocation failed","Fatal Error",0)
      endif
      this.ptr = h
   return h
endclass

